﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Place" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

    Date PoliczKoniecOZ(INieobecnosc Nieobecność) {       
        OkresNieobecności on = (OkresNieobecności)Nieobecność;
        Nieobecnosc nieobecność = (Nieobecnosc)on;
        CięcieChorobowego cięcie = new CięcieChorobowego(nieobecność, on.Okres * FromTo.Year(on.Okres.From.Year));
        cięcie.Tnij(Periods.Empty);
        return cięcie.DataNiePłacimy;
    }
    
    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        KalkulatorPracy kp = new KalkulatorPracy(idx);
        bool wchodzi = false;
        foreach (INieobecnosc nieobecność in kp.Nieobecnosci(okresRaportu, false)) {
            if (nieobecność.Definicja.Rozliczenie==RozliczenieNieobecnosci.JakZwolnienieChorobowe) {
                Date data = PoliczKoniecOZ(nieobecność);
                if (data <= nieobecność.Okres.To && data<=okresRaportu.To) {
                    wchodzi = true;
                    colNie.AddLine(nieobecność.Definicja.Nazwa + " (" + nieobecność.Okres + ")");
                    colEnd.AddLine(data);
                }
            }
        }
        colZatrudnienie.EditValue = GetStanowisko(idx[((ActualDate)dc[typeof(ActualDate)]).Actual]);
        
        args.VisibleRow = wchodzi;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }    
    
    FromTo okresRaportu;
    protected void dc_ContextLoad(object sender, EventArgs e) {
        okresRaportu = ((OkresContext)dc[typeof(OkresContext)]).Okres;
    }

    static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Koniec okresu zasiłkowego</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Koniec okresu zasiłkowego|</strong>Wydział: <strong>{0}|</strong>Pośrednio: <strong>{1}|</strong>Okres: <strong>{2}|</strong>Aktualny: <strong>{3}" DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" DataMember2="KadryPracownicyViewInfo+PrParams.Okres" DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" OnBeforeRow="Grid_BeforeRow" RowsInRow="2">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" RowSpan="2"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik" Caption="Pracownik" ColSpan="2"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" ID="colZatrudnienie" Caption="Stanowisko"></ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Okres zatrudnienia" DataMember="Workers.Info.Historia.Etat.OkresZatrudnienia"
                        Width="20">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colNie" runat="server" Caption="Nieobecność" Width="45" NoWrap="True" RowSpan="2">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colEnd" runat="server" Align="Center" Caption="Koniec okr. zas."
                        Width="15" RowSpan="2">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

